//-----------------------------------------------------------------------------
// File: i dream of norway.cpp
//
// Desc: DirectX MFC dialog application created by the DirectX AppWizard
//-----------------------------------------------------------------------------
#define STRICT
#define DIRECTINPUT_VERSION 0x0800
#include "stdafx.h"
#include "i dream of norway.h"




//-----------------------------------------------------------------------------
// Application globals
//-----------------------------------------------------------------------------
TCHAR*          g_strAppTitle       = _T( "i dream of norway" );
CApp            g_App;
HINSTANCE       g_hInst = NULL;
CAppForm*       g_AppFormView = NULL;




//-----------------------------------------------------------------------------
// The MFC macros are all listed here
//-----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE( CAppDoc,      CDocument )
IMPLEMENT_DYNCREATE( CAppFrameWnd, CFrameWnd )
IMPLEMENT_DYNCREATE( CAppForm,     CFormView )




BEGIN_MESSAGE_MAP( CApp, CWinApp )
    //{{AFX_MSG_MAP(CApp)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP( CAppForm, CFormView )
    //{{AFX_MSG_MAP(CAppForm)
    ON_COMMAND(    IDC_VIEWFULLSCREEN, OnToggleFullScreen )
    ON_BN_CLICKED(IDC_CHANGEDEVICE, OnChangeDevice)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP(CAppDoc, CDocument)
    //{{AFX_MSG_MAP(CAppDoc)
            // NOTE - the ClassWizard will add and remove mapping macros here.
            //    DO NOT EDIT what you see in these blocks of generated code!
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP(CAppFrameWnd, CFrameWnd)
    //{{AFX_MSG_MAP(CAppFrameWnd)
    ON_COMMAND(IDM_CHANGEDEVICE, OnChangeDevice)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()




//-----------------------------------------------------------------------------
// Name: CAppForm()
// Desc: Constructor for the dialog resource form.  Paired with ~CAppForm()
//       Member variables should be initialized to a known state here.  
//       The application window has not yet been created and no Direct3D device 
//       has been created, so any initialization that depends on a window or 
//       Direct3D should be deferred to a later stage. 
//-----------------------------------------------------------------------------
CAppForm::CAppForm()
         :CFormView( IDD_FORMVIEW )
{
    //{{AFX_DATA_INIT(CAppForm)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT

    g_AppFormView          = this;
    m_hwndRenderWindow     = NULL;
    m_hwndRenderFullScreen = NULL;
    m_hWndTopLevelParent   = NULL;

    // Override some CD3DApplication defaults:
    m_dwCreationWidth           = 500;
    m_dwCreationHeight          = 375;
    m_strWindowTitle            = TEXT( "i dream of norway" );
    m_d3dEnumeration.AppUsesDepthBuffer   = TRUE;
	m_bStartFullscreen			= false;
	m_bShowCursorWhenFullscreen	= false;

    m_pD3DXFont                 = NULL;
    m_bLoadingApp               = TRUE;
    m_pVB                       = NULL;
    m_pDI                       = NULL;
    m_pKeyboard                 = NULL;

    ZeroMemory( &m_UserInput, sizeof(m_UserInput) );
    m_fWorldRotX                = 0.0f;
    m_fWorldRotY                = 0.0f;

    // Read settings from registry
    ReadSettings();



    // <oxe 20041103>
    m_TMin      = -3.14159265359f * 2.0f;
    m_TMax      = -m_TMin;
    m_NumPoints = 0;
    m_pVBLines  = NULL;
    // </oxe>

}




//-----------------------------------------------------------------------------
// Name: CAppForm::OneTimeSceneInit()
// Desc: Paired with FinalCleanup().
//       The window has been created and the IDirect3D9 interface has been
//       created, but the device has not been created yet.  Here you can
//       perform application-related initialization and cleanup that does
//       not depend on a device.
//-----------------------------------------------------------------------------
HRESULT CAppForm::OneTimeSceneInit()
{
    // TODO: perform one time initialization

    // Initialize DirectInput
    InitInput( m_hWndTopLevelParent );

    m_bLoadingApp = FALSE;

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: ReadSettings()
// Desc: Read the app settings from the registry
//-----------------------------------------------------------------------------
VOID CAppForm::ReadSettings()
{
    HKEY hkey;
    if( ERROR_SUCCESS == RegCreateKeyEx( HKEY_CURRENT_USER, DXAPP_KEY, 
        0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, NULL ) )
    {
        // TODO: change as needed

        // Read the stored window width/height.  This is just an example,
        // of how to use DXUtil_Read*() functions.
        DXUtil_ReadIntRegKey( hkey, TEXT("Width"), &m_dwCreationWidth, m_dwCreationWidth );
        DXUtil_ReadIntRegKey( hkey, TEXT("Height"), &m_dwCreationHeight, m_dwCreationHeight );

        RegCloseKey( hkey );
    }
}




//-----------------------------------------------------------------------------
// Name: WriteSettings()
// Desc: Write the app settings to the registry
//-----------------------------------------------------------------------------
VOID CAppForm::WriteSettings()
{
    HKEY hkey;

    if( ERROR_SUCCESS == RegCreateKeyEx( HKEY_CURRENT_USER, DXAPP_KEY, 
        0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, NULL ) )
    {
        // TODO: change as needed

        // Write the window width/height.  This is just an example,
        // of how to use DXUtil_Write*() functions.
        DXUtil_WriteIntRegKey( hkey, TEXT("Width"), m_rcWindowClient.right );
        DXUtil_WriteIntRegKey( hkey, TEXT("Height"), m_rcWindowClient.bottom );

        RegCloseKey( hkey );
    }
}





//-----------------------------------------------------------------------------
// Name: InitInput()
// Desc: Initialize DirectInput objects
//-----------------------------------------------------------------------------
HRESULT CAppForm::InitInput( HWND hWnd )
{
    HRESULT hr;

    // Create a IDirectInput8*
    if( FAILED( hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION, 
                                         IID_IDirectInput8, (VOID**)&m_pDI, NULL ) ) )
        return DXTRACE_ERR( "DirectInput8Create", hr );
    
    // Create a IDirectInputDevice8* for the keyboard
    if( FAILED( hr = m_pDI->CreateDevice( GUID_SysKeyboard, &m_pKeyboard, NULL ) ) )
        return DXTRACE_ERR( "CreateDevice", hr );
    
    // Set the keyboard data format
    if( FAILED( hr = m_pKeyboard->SetDataFormat( &c_dfDIKeyboard ) ) )
        return DXTRACE_ERR( "SetDataFormat", hr );
    
    // Set the cooperative level on the keyboard
    if( FAILED( hr = m_pKeyboard->SetCooperativeLevel( hWnd, 
                                            DISCL_NONEXCLUSIVE | 
                                            DISCL_FOREGROUND | 
                                            DISCL_NOWINKEY ) ) )
        return DXTRACE_ERR( "SetCooperativeLevel", hr );

    // Acquire the keyboard
    m_pKeyboard->Acquire();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: ConfirmDevice()
// Desc: Called during device initialization, this code checks the display device
//       for some minimum set of capabilities
//-----------------------------------------------------------------------------
HRESULT CAppForm::ConfirmDevice( D3DCAPS9* pCaps, DWORD dwBehavior,
                                          D3DFORMAT Format )
{
    UNREFERENCED_PARAMETER( pCaps );
    UNREFERENCED_PARAMETER( dwBehavior );
    UNREFERENCED_PARAMETER( Format );
    BOOL bCapsAcceptable;

    // TODO: Perform checks to see if these display caps are acceptable.
    bCapsAcceptable = TRUE;

    if( bCapsAcceptable )         
        return S_OK;
    else
        return E_FAIL;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::InitDeviceObjects()
// Desc: Paired with DeleteDeviceObjects()
//       The device has been created.  Resources that are not lost on
//       Reset() can be created here -- resources in D3DPOOL_MANAGED,
//       D3DPOOL_SCRATCH, or D3DPOOL_SYSTEMMEM.  Image surfaces created via
//       CreateImageSurface are never lost and can be created here.  Vertex
//       shaders and pixel shaders can also be created here as they are not
//       lost on Reset().
//-----------------------------------------------------------------------------
HRESULT CAppForm::InitDeviceObjects()
{
    // TODO: create device objects

    HRESULT hr;

    // Create the vertex buffer
    if( FAILED( hr = m_pd3dDevice->CreateVertexBuffer( 3*2*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_MANAGED, &m_pVB, NULL ) ) )
        return DXTRACE_ERR( "CreateVertexBuffer", hr );

    // Fill the vertex buffer with 2 triangles
    CUSTOMVERTEX* pVertices;

    if( FAILED( hr = m_pVB->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
        return DXTRACE_ERR( "Lock", hr );

    // Front triangle
    pVertices[0].position = D3DXVECTOR3( -1.0f, -1.0f,  0.0f );
    pVertices[0].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );
    pVertices[1].position = D3DXVECTOR3(  0.0f,  1.0f,  0.0f );
    pVertices[1].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );
    pVertices[2].position = D3DXVECTOR3(  1.0f, -1.0f,  0.0f );
    pVertices[2].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );

    // Back triangle
    pVertices[3].position = D3DXVECTOR3( -1.0f, -1.0f,  0.0f );
    pVertices[3].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );
    pVertices[4].position = D3DXVECTOR3(  1.0f, -1.0f,  0.0f );
    pVertices[4].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );
    pVertices[5].position = D3DXVECTOR3(  0.0f,  1.0f,  0.0f );
    pVertices[5].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );

    m_pVB->Unlock();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::RestoreDeviceObjects()
// Desc: Paired with InvalidateDeviceObjects()
//       The device exists, but may have just been Reset().  Resources in
//       D3DPOOL_DEFAULT and any other device state that persists during
//       rendering should be set here.  Render states, matrices, textures,
//       etc., that don't change during rendering can be set once here to
//       avoid redundant state setting during Render() or FrameMove().
//-----------------------------------------------------------------------------
HRESULT CAppForm::RestoreDeviceObjects()
{
    // TODO: setup render states
    HRESULT hr;

    // Setup a material
    D3DMATERIAL9 mtrl;
    D3DUtil_InitMaterial( mtrl, 1.0f, 1.0f, 1.0f );
    mtrl.Diffuse=D3DXCOLOR(1,1,1,1);
    m_pd3dDevice->SetMaterial( &mtrl );

    // Set up the textures
/*
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
    m_pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
    m_pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
*/
    

    // Set the world matrix
    D3DXMATRIX matIdentity;
    D3DXMatrixIdentity( &matIdentity );
    m_pd3dDevice->SetTransform( D3DTS_WORLD,  &matIdentity );

    // Set up our view matrix. A view matrix can be defined given an eye point,
    // a point to lookat, and a direction for which way is up. Here, we set the
    // eye five units back along the z-axis and up three units, look at the
    // origin, and define "up" to be in the y-direction.
    D3DXMATRIX matView;
    D3DXVECTOR3 vFromPt   = D3DXVECTOR3( 0.0f, 0.0f, -5.0f );
    D3DXVECTOR3 vLookatPt = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
    D3DXVECTOR3 vUpVec    = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
    D3DXMatrixLookAtLH( &matView, &vFromPt, &vLookatPt, &vUpVec );
    m_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

    // Set the projection matrix
    D3DXMATRIX matProj;
    FLOAT fAspect = ((FLOAT)m_d3dsdBackBuffer.Width) / m_d3dsdBackBuffer.Height;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, fAspect, 1.0f, 100.0f );
    m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );

    // Create a D3D font using D3DX
    HFONT hFont = CreateFont( 20, 0, 0, 0, FW_BOLD, FALSE, FALSE, FALSE,
                              ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                              ANTIALIASED_QUALITY, FF_DONTCARE, "Arial" );      
    if( FAILED( hr = D3DXCreateFont( m_pd3dDevice, hFont, &m_pD3DXFont ) ) )
        return DXTRACE_ERR( "D3DXCreateFont", hr );

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::FrameMove()
// Desc: Called once per frame, the call is the entry point for animating
//       the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::FrameMove()
{
    // TODO: update world

    // Update user input state
    UpdateInput( &m_UserInput );

    // Update the world state according to user input
    D3DXMATRIX matWorld;
    D3DXMATRIX matRotY;
    D3DXMATRIX matRotX;
    D3DXMATRIX matScale;

    BOOL move;

    move = m_gui_Check6.GetCheck() & 3;

    if( m_UserInput.bRotateLeft && !m_UserInput.bRotateRight || move)
        m_fWorldRotY += m_fElapsedTime;
    else if( m_UserInput.bRotateRight && !m_UserInput.bRotateLeft )
        m_fWorldRotY -= m_fElapsedTime;

    if( m_UserInput.bRotateUp && !m_UserInput.bRotateDown || move)
        m_fWorldRotX += m_fElapsedTime;
    else if( m_UserInput.bRotateDown && !m_UserInput.bRotateUp )
        m_fWorldRotX -= m_fElapsedTime;

    D3DXMatrixRotationX( &matRotX, m_fWorldRotX );
    D3DXMatrixRotationY( &matRotY, m_fWorldRotY );

    float scale;
    scale = (float)m_gui_Slider1.GetPos();
    scale = (100.0f - scale) / 100.0f;
    scale *= 2.0f;

    D3DXMatrixScaling  ( &matScale, scale, scale, scale );

    D3DXMatrixMultiply( &matWorld, &matRotX , &matRotY );
    D3DXMatrixMultiply( &matWorld, &matWorld, &matScale );
    m_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );


    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: UpdateInput()
// Desc: Update the user input.  Called once per frame 
//-----------------------------------------------------------------------------
void CAppForm::UpdateInput( UserInput* pUserInput )
{
    HRESULT hr;

    // Get the input's device state, and put the state in dims
    ZeroMemory( &pUserInput->diks, sizeof(pUserInput->diks) );
    hr = m_pKeyboard->GetDeviceState( sizeof(pUserInput->diks), &pUserInput->diks );
    if( FAILED(hr) ) 
    {
        m_pKeyboard->Acquire();
        return; 
    }

    // TODO: Process user input as needed
    pUserInput->bRotateLeft  = ( (pUserInput->diks[DIK_LEFT] & 0x80)  == 0x80 );
    pUserInput->bRotateRight = ( (pUserInput->diks[DIK_RIGHT] & 0x80) == 0x80 );
    pUserInput->bRotateUp    = ( (pUserInput->diks[DIK_UP] & 0x80)    == 0x80 );
    pUserInput->bRotateDown  = ( (pUserInput->diks[DIK_DOWN] & 0x80)  == 0x80 );
}




//-----------------------------------------------------------------------------
// Name: CAppForm::Render()
// Desc: Called once per frame, the call is the entry point for 3d
//       rendering. This function sets up render states, clears the
//       viewport, and renders the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::Render()
{
   // Clear the viewport
   m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
    0x000000ff, 1.0f, 0L );

   // Begin the scene
   if( !SUCCEEDED( m_pd3dDevice->BeginScene() ) )
      return -1;

   // two lights because i am lame and can't get emissive color in the points.

   D3DLIGHT9 light;
   D3DUtil_InitLight        ( light, D3DLIGHT_DIRECTIONAL, -1.0f, -1.0f, 2.0f );
   m_pd3dDevice->SetLight   ( 0, &light );
   m_pd3dDevice->LightEnable( 0, TRUE );
   
   D3DLIGHT9 light2;
   D3DUtil_InitLight        ( light2, D3DLIGHT_DIRECTIONAL, 1.0f, 1.0f, 2.0f );
   m_pd3dDevice->SetLight   ( 1, &light2 );
   m_pd3dDevice->LightEnable( 1, TRUE );

   m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, m_gui_Check5.GetCheck() & 3);


   float pointSize = 3.0f;
   m_pd3dDevice->SetRenderState( D3DRS_POINTSIZE,        *((DWORD*)&pointSize));

   m_pd3dDevice->SetRenderState( D3DRS_DITHERENABLE,   FALSE );
   m_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, !TRUE );
   m_pd3dDevice->SetRenderState( D3DRS_ZENABLE,        TRUE );
   m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x000f0f0f);


   if (m_gui_Check3.GetCheck() & 3)
   {
      m_pd3dDevice->SetStreamSource( 0, m_pVB, 0, sizeof(CUSTOMVERTEX) );
      m_pd3dDevice->SetFVF( D3DFVF_CUSTOMVERTEX );
      m_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
   }

   if (m_gui_Check1.GetCheck() & 3)
   {
      m_pd3dDevice->SetStreamSource( 0, m_pVBLines, 0, sizeof(CUSTOMVERTEX2) );
      m_pd3dDevice->SetFVF         ( D3DFVF_CUSTOMVERTEX2 );
      m_pd3dDevice->DrawPrimitive  ( D3DPT_POINTLIST, 0, m_NumPoints );
   }

   if (m_gui_Check2.GetCheck() & 3)
   {
      m_pd3dDevice->SetStreamSource( 0, m_pVBLines, 0, sizeof(CUSTOMVERTEX2) );
      m_pd3dDevice->SetFVF         ( D3DFVF_CUSTOMVERTEX2 );
      m_pd3dDevice->DrawPrimitive  ( D3DPT_LINESTRIP, 0, m_NumPoints - 1    );
   }


   if (m_gui_Check4.GetCheck() & 3)
      RenderText();

   // End the scene.
   m_pd3dDevice->EndScene();

   return S_OK;
}




//-----------------------------------------------------------------------------
// Name: RenderText()
// Desc: Renders stats and help text to the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::RenderText()
{
    D3DCOLOR fontColor        = D3DCOLOR_ARGB(255,255,255,0);
    TCHAR szMsg[MAX_PATH] = TEXT("");
    RECT rct;
    ZeroMemory( &rct, sizeof(rct) );       

    m_pD3DXFont->Begin();
    rct.left   = 2;
    rct.right  = m_d3dsdBackBuffer.Width - 20;

    // Output display stats
    INT nNextLine = 40; 

    lstrcpy( szMsg, m_strDeviceStats );
    nNextLine -= 20; rct.top = nNextLine; rct.bottom = rct.top + 20;    
    m_pD3DXFont->DrawText( szMsg, -1, &rct, 0, fontColor );

    lstrcpy( szMsg, m_strFrameStats );
    nNextLine -= 20; rct.top = nNextLine; rct.bottom = rct.top + 20;    
    m_pD3DXFont->DrawText( szMsg, -1, &rct, 0, fontColor );

    // Output statistics & help
    nNextLine = m_d3dsdBackBuffer.Height; 

    wsprintf( szMsg, TEXT("Arrow keys: Up=%d Down=%d Left=%d Right=%d"), 
              m_UserInput.bRotateUp, m_UserInput.bRotateDown, m_UserInput.bRotateLeft, m_UserInput.bRotateRight );
    nNextLine -= 20; rct.top = nNextLine; rct.bottom = rct.top + 20;    
    m_pD3DXFont->DrawText( szMsg, -1, &rct, 0, fontColor );

    lstrcpy( szMsg, TEXT("Use arrow keys to rotate object") );
    nNextLine -= 20; rct.top = nNextLine; rct.bottom = rct.top + 20;    
    m_pD3DXFont->DrawText( szMsg, -1, &rct, 0, fontColor );

    lstrcpy( szMsg, TEXT("Press 'F2' to configure display") );
    nNextLine -= 20; rct.top = nNextLine; rct.bottom = rct.top + 20;    
    m_pD3DXFont->DrawText( szMsg, -1, &rct, 0, fontColor );

    m_pD3DXFont->End();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: DoDataExchange()
// Desc: DDX/DDV support
//-----------------------------------------------------------------------------
void CAppForm::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAppForm)
	DDX_Control(pDX, IDC_CHECK6, m_gui_Check6);
	DDX_Control(pDX, IDC_SLIDER2, m_gui_Slider2);
	DDX_Control(pDX, IDC_EDIT6, m_gui_Edit6);
	DDX_Control(pDX, IDC_EDIT5, m_gui_Edit5);
	DDX_Control(pDX, IDC_EDIT4, m_gui_Edit4);
	DDX_Control(pDX, IDC_COMBO1, m_gui_Combo1);
	DDX_Control(pDX, IDC_SLIDER1, m_gui_Slider1);
	DDX_Control(pDX, IDC_CHECK5, m_gui_Check5);
	DDX_Control(pDX, IDC_CHECK4, m_gui_Check4);
	DDX_Control(pDX, IDC_CHECK3, m_gui_Check3);
	DDX_Control(pDX, IDC_CHECK2, m_gui_Check2);
	DDX_Control(pDX, IDC_CHECK1, m_gui_Check1);
	DDX_Control(pDX, IDC_EDIT3, m_gui_Edit3);
	DDX_Control(pDX, IDC_EDIT2, m_gui_Edit2);
	DDX_Control(pDX, IDC_EDIT1, m_gui_Edit1);
	//}}AFX_DATA_MAP
}




//-----------------------------------------------------------------------------
// Name: WindowProc()
// Desc: 
//-----------------------------------------------------------------------------
LRESULT CAppForm::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
    return CFormView ::WindowProc(message, wParam, lParam);
}




//-----------------------------------------------------------------------------
// Name: OnChangeDevice()
// Desc: Needed to enable dlg menu item 
//-----------------------------------------------------------------------------
void CAppFrameWnd::OnChangeDevice() 
{
    g_AppFormView->OnChangeDevice();
}




//-----------------------------------------------------------------------------
// Name: CAppForm::InvalidateDeviceObjects()
// Desc: Invalidates device objects.  Paired with RestoreDeviceObjects()
//-----------------------------------------------------------------------------
HRESULT CAppForm::InvalidateDeviceObjects()
{
    // TODO: Cleanup any objects created in RestoreDeviceObjects()
    SAFE_RELEASE( m_pD3DXFont );
    SetNumPoints(m_pVBLines, 0);

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::DeleteDeviceObjects()
// Desc: Paired with InitDeviceObjects()
//       Called when the app is exiting, or the device is being changed,
//       this function deletes any device dependent objects.  
//-----------------------------------------------------------------------------
HRESULT CAppForm::DeleteDeviceObjects()
{
    // TODO: Cleanup any objects created in InitDeviceObjects()
    SAFE_RELEASE( m_pVB );

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::FinalCleanup()
// Desc: Paired with OneTimeSceneInit()
//       Called before the app exits, this function gives the app the chance
//       to cleanup after itself.
//-----------------------------------------------------------------------------
HRESULT CAppForm::FinalCleanup()
{
    // TODO: Perform any final cleanup needed
    // Cleanup DirectInput
    CleanupDirectInput();

    // Write the settings to the registry
    WriteSettings();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CleanupDirectInput()
// Desc: Cleanup DirectInput 
//-----------------------------------------------------------------------------
VOID CAppForm::CleanupDirectInput()
{
    // Cleanup DirectX input objects
    SAFE_RELEASE( m_pKeyboard );
    SAFE_RELEASE( m_pDI );

}




//-----------------------------------------------------------------------------
// Name: InitInstance()
// Desc: This is the main entry point for the application. The MFC window stuff
//       is initialized here. See also the main initialization routine for the
//       CAppForm class, which is called indirectly from here.
//-----------------------------------------------------------------------------
BOOL CApp::InitInstance()
{
    // Asscociate the MFC app with the frame window and doc/view classes
    AddDocTemplate( new CSingleDocTemplate( IDR_MAINFRAME,
                                            RUNTIME_CLASS(CAppDoc),
                                            RUNTIME_CLASS(CAppFrameWnd),
                                            RUNTIME_CLASS(CAppForm) ) );

    // Dispatch commands specified on the command line (req'd by MFC). This
    // also initializes the the CAppDoc, CAppFrameWnd, and CAppForm classes.
    CCommandLineInfo cmdInfo;
    ParseCommandLine( cmdInfo );
    if( !ProcessShellCommand( cmdInfo ) )
        return FALSE;

    if( !g_AppFormView->IsReady() )
        return FALSE;

    g_AppFormView->GetParentFrame()->RecalcLayout();
    g_AppFormView->ResizeParentToFit( FALSE ); 
    
    m_pMainWnd->SetWindowText( g_strAppTitle );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}




//-----------------------------------------------------------------------------
// Name: LoadFrame()
// Desc: Uses idle time to render the 3D scene.
//-----------------------------------------------------------------------------
BOOL CAppFrameWnd::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
    BOOL bResult = CFrameWnd::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext);
    
    LoadAccelTable( MAKEINTRESOURCE(IDR_MAIN_ACCEL) );

    return bResult;
}




//-----------------------------------------------------------------------------
// Name: OnIdle()
// Desc: Uses idle time to render the 3D scene.
//-----------------------------------------------------------------------------
BOOL CApp::OnIdle( LONG )
{
    // Do not render if the app is minimized
    if( m_pMainWnd->IsIconic() )
        return FALSE;

    TCHAR strStatsPrev[200];

    lstrcpy(strStatsPrev, g_AppFormView->PstrFrameStats());

    // Update and render a frame
    if( g_AppFormView->IsReady() )
    {
        g_AppFormView->CheckForLostFullscreen();
        g_AppFormView->RenderScene();
        Sleep(10);
    }

    // Keep requesting more idle time
    return TRUE;
}




//-----------------------------------------------------------------------------
// Name: PreCreateWindow()
// Desc: Change the window style (so it cannot maximize or be sized) before
//       the main frame window is created.
//-----------------------------------------------------------------------------
BOOL CAppFrameWnd::PreCreateWindow( CREATESTRUCT& cs )
{
    cs.style = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX;

    return CFrameWnd::PreCreateWindow( cs );
}




//-----------------------------------------------------------------------------
// Name: ~CAppForm()
// Desc: Destructor for the dialog resource form. Shuts down the app
//-----------------------------------------------------------------------------
CAppForm::~CAppForm()
{
    Cleanup3DEnvironment();
    SAFE_RELEASE( m_pD3D );
    FinalCleanup();
}




//-----------------------------------------------------------------------------
// Name: OnToggleFullScreen()
// Desc: Called when user toggles the fullscreen mode
//-----------------------------------------------------------------------------
void CAppForm::OnToggleFullScreen()
{
    ToggleFullscreen();
}




//-----------------------------------------------------------------------------
// Name: OnChangeDevice()
// Desc: Use hit the "Change Device.." button. Display the dialog for the user
//       to select a new device/mode, and call Change3DEnvironment to
//       use the new device/mode.
//-----------------------------------------------------------------------------
VOID CAppForm::OnChangeDevice()
{
    Pause(true);

    UserSelectNewDevice();

    // Update UI
    UpdateUIForDeviceCapabilites();

    Pause(false);
}




//-----------------------------------------------------------------------------
// Name: AdjustWindowForChange()
// Desc: Adjusts the window properties for windowed or fullscreen mode
//-----------------------------------------------------------------------------
HRESULT CAppForm::AdjustWindowForChange()
{
    if( m_bWindowed )
    {
        ::ShowWindow( m_hwndRenderFullScreen, SW_HIDE );
        CD3DApplication::m_hWnd = m_hwndRenderWindow;

        // Tell the action mapper that the focus wnd has changed
        m_pKeyboard->SetCooperativeLevel( m_hWndTopLevelParent, 
                                                DISCL_NONEXCLUSIVE | 
                                                DISCL_FOREGROUND | 
                                                DISCL_NOWINKEY );
    }
    else
    {
        if( ::IsIconic( m_hwndRenderFullScreen ) )
            ::ShowWindow( m_hwndRenderFullScreen, SW_RESTORE );
        ::ShowWindow( m_hwndRenderFullScreen, SW_SHOW );
        CD3DApplication::m_hWnd = m_hwndRenderFullScreen;

        // Tell the action mapper that the focus wnd has changed
        m_pKeyboard->SetCooperativeLevel( m_hwndRenderFullScreen, 
                                                DISCL_NONEXCLUSIVE | 
                                                DISCL_FOREGROUND | 
                                                DISCL_NOWINKEY );
    }

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: FullScreenWndProc()
// Desc: The WndProc funtion used when the app is in fullscreen mode. This is
//       needed simply to trap the ESC key.
//-----------------------------------------------------------------------------
LRESULT CALLBACK FullScreenWndProc( HWND hWnd, UINT msg, WPARAM wParam,
                                    LPARAM lParam )
{
    if( msg == WM_CLOSE )
    {
        // User wants to exit, so go back to windowed mode and exit for real
        g_AppFormView->OnToggleFullScreen();
        g_App.GetMainWnd()->PostMessage( WM_CLOSE, 0, 0 );
    }
    else if( msg == WM_SETCURSOR )
    {
        SetCursor( NULL );
    }
    else if( msg == WM_KEYUP && wParam == VK_ESCAPE )
    {
        // User wants to leave fullscreen mode
        g_AppFormView->OnToggleFullScreen();
    }

    return DefWindowProc( hWnd, msg, wParam, lParam );
}




//-----------------------------------------------------------------------------
// Name: CheckForLostFullscreen()
// Desc: If fullscreen and device was lost (probably due to alt-tab), 
//       automatically switch to windowed mode
//-----------------------------------------------------------------------------
HRESULT CAppForm::CheckForLostFullscreen()
{
    HRESULT hr;

    if( m_bWindowed )
        return S_OK;

    if( FAILED( hr = m_pd3dDevice->TestCooperativeLevel() ) )
        ForceWindowed();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: UpdateUIForDeviceCapabilites()
// Desc: Whenever we get a new device, call this function to enable/disable the
//       appropiate UI controls to match the device's capabilities.
//-----------------------------------------------------------------------------
VOID CAppForm::UpdateUIForDeviceCapabilites()
{
    // TODO: Check the capabilities of the device and update the UI as needed
    DWORD dwCaps = m_d3dCaps.RasterCaps;
    UNREFERENCED_PARAMETER( dwCaps );
}




//-----------------------------------------------------------------------------
// Name: OnInitialUpdate()
// Desc: When the AppForm object is created, this function is called to
//       initialize it. Here we getting access ptrs to some of the controls,
//       and setting the initial state of some of them as well.
//-----------------------------------------------------------------------------
VOID CAppForm::OnInitialUpdate()
{
    // Update the UI
    CFormView::OnInitialUpdate();

    // Get the top level parent hwnd
    m_hWndTopLevelParent = GetTopLevelParent()->GetSafeHwnd();

    // Save static reference to the render window
    m_hwndRenderWindow = GetDlgItem(IDC_RENDERVIEW)->GetSafeHwnd();

    // Register a class for a fullscreen window
    WNDCLASS wndClass = { CS_HREDRAW | CS_VREDRAW, FullScreenWndProc, 0, 0, NULL,
                          NULL, NULL, (HBRUSH)GetStockObject(WHITE_BRUSH), NULL,
                          _T("Fullscreen Window") };
    RegisterClass( &wndClass );

    // We create the fullscreen window (not visible) at startup, so it can
    // be the focus window.  The focus window can only be set at CreateDevice
    // time, not in a Reset, so ToggleFullscreen wouldn't work unless we have
    // already set up the fullscreen focus window.
    m_hwndRenderFullScreen = CreateWindow( _T("Fullscreen Window"), NULL,
                                           WS_POPUP, CW_USEDEFAULT,
                                           CW_USEDEFAULT, 100, 100,
                                           m_hWndTopLevelParent, 0L, NULL, 0L );

    // Note that for the MFC samples, the device window and focus window
    // are not the same.
    CD3DApplication::m_hWnd = m_hwndRenderWindow;
    CD3DApplication::m_hWndFocus = m_hwndRenderFullScreen;
    CD3DApplication::Create( AfxGetInstanceHandle() );

    // TODO: Update the UI as needed

   
   m_gui_Edit1  .SetWindowText(" 3.14159");
   m_gui_Edit2  .SetWindowText("-3.14159");
   m_gui_Edit3  .SetWindowText("20000");
   m_gui_Edit4  .SetWindowText(" 0.0");
   m_gui_Edit5  .SetWindowText(" 2.0");
   TweenNumbers();
   m_gui_Check1 .SetCheck     ( TRUE); // points
   m_gui_Check2 .SetCheck     (!TRUE); // lines
   m_gui_Check3 .SetCheck     (!TRUE); // triangle
   m_gui_Check4 .SetCheck     (!TRUE); // words
   m_gui_Check5 .SetCheck     ( TRUE); // lights
   m_gui_Check6 .SetCheck     ( TRUE); // move

   m_gui_Slider1.SetPos       (50);

   m_gui_Combo1.AddString("coil" );
   m_gui_Combo1.AddString("crazy");
   m_gui_Combo1.AddString("Insane Scribble Ball");
   m_gui_Combo1.SetCurSel(2);

   OnButton1();

}

void CAppForm::SetNumPoints(LPDIRECT3DVERTEXBUFFER9& pvb, int num)
{
   SAFE_RELEASE(pvb);

   m_NumPoints = 0;

   if (num < 1)
      return;

   if (FAILED(m_pd3dDevice->CreateVertexBuffer(num*sizeof(CUSTOMVERTEX2),
                                         0, D3DFVF_CUSTOMVERTEX2,
                                         D3DPOOL_MANAGED, &pvb, NULL)))
      return;

   m_NumPoints = num;
}


typedef void (*TheFunctionType) (float, float*, float*, float*, float*);

static void Coil(float t, float* pos, float* nrm, float* color, float* params)
{
   pos[0] = cosf(t * params[0]);
   pos[1] = sinf(t * params[0]);
   pos[2] = t * .1f;

   // now for the normal.
   // for a more complicated function than a coil,
   // yer pretty much on your own.
   // a reasonable thing might be just a copy of the position
   // but normalized to length one.
   float f;
   f = pos[0] * pos[0] + pos[1] * pos[1];// + pos[2] * pos[2];
   f = sqrtf(f);
   f = 3.0f / f;          // this is a hack to get brighter lighting. normals *should* be length 1.
   nrm[0] = pos[0] * f;
   nrm[1] = pos[1] * f;
   nrm[2] = 0.0f;

   color[0] = -sinf(t * 4.9f ) * 0.2f + 0.8f;
   color[1] = -sinf(t * 4.9f ) * 0.2f + 0.8f;
   color[2] =  sinf(t * 8.1f ) * 0.5f + 0.5f;
   color[3] = 1.0f;

   // kill compiler warnings:
   params = params;
}



static void Crazy(float t, float* pos, float* nrm, float* color, float* params)
{
   // Some nutty function in polar coords

   float theta;
   float phi;
   float rho;

   theta = t;
   phi   = t;
   rho   = sinf(t*.25f * params[0]);

   
	// spherical to cartesian
	pos[0] = rho * sinf(phi) * cosf(theta);
	pos[1] = rho * cosf(phi);
	pos[2] = rho * sinf(phi) * sinf(theta);

   
   // now for the normal.
   float f;
   f = pos[0] * pos[0] + pos[1] * pos[1] + pos[2] * pos[2];
   f = sqrtf(f);
   f = 3.0f / f;          // this is a hack to get brighter lighting. normals *should* be length 1.
   nrm[0] = pos[0] * f;
   nrm[1] = pos[1] * f;
   nrm[2] = pos[2] * f;

   color[0] = -sinf(t * 4.9f ) * 0.2f + 0.8f;
   color[1] = -sinf(t * 4.9f ) * 0.2f + 0.8f;
   color[2] =  sinf(t * 8.1f ) * 0.5f + 0.5f;
   color[3] = 1.0f;

   // kill compiler warnings:
   params = params;
}

static void InsaneScribbleBall(float t, float* pos, float* nrm, float* color, float* params)
{
   // Some nutty function in polar coords

   float theta;
   float phi;
   float rho;

   float yob;
   float bob;
   float tob;
   float pi = 3.14159265359f;


   yob = t * 9.0f;
   bob = 0.8f;
   tob = params[0];

   theta  = t + sinf(yob * 2.0f) * pi / 8.0f;
   theta += sinf(yob * 16.0f) * pi / 32.0f * tob;
   phi    = 3.14159f * 0.5f;
   phi   += sinf(yob) * bob;
   phi   += cosf(yob * 16.0f) * pi / 32.0f * tob;
   rho    = 1.0f + sinf(yob * 2.0f) * 0.125f;

   
	// spherical to cartesian
	pos[0] = rho * sinf(phi) * cosf(theta);
	pos[1] = rho * cosf(phi);
	pos[2] = rho * sinf(phi) * sinf(theta);

   
   // now for the normal.
   float f;
   f = pos[0] * pos[0] + pos[1] * pos[1] + pos[2] * pos[2];
   f = sqrtf(f);
   f = 2.0f / f;          // this is a hack to get brighter lighting. normals *should* be length 1.
   nrm[0] = pos[0] * f;
   nrm[1] = pos[1] * f;
   nrm[2] = pos[2] * f;

   color[0] = sinf(yob * 2.0f + 0.0f   ) * 0.3f + 0.7f;
   color[1] = sinf(yob * 2.0f + pi/3.0f) * 0.3f + 0.7f;
   color[2] = sinf(yob * 4.0f + pi/1.5f) * 0.3f + 0.7f;
   color[3] = 1.0f;
}









void CAppForm::RegenerateGeometry()
{
   SetNumPoints(m_pVBLines, m_NumPoints);

   if (!m_pVBLines)
      return;

   CUSTOMVERTEX2* pVertices;

   if( FAILED(m_pVBLines->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
      return;


   float         t;
   float         dt;
   float         pos[3];
   float         nrm[3];
   float         clr[3];
   float         params[1];
   int           i;
   CUSTOMVERTEX2* vtx;

   CString cs;
   m_gui_Edit6.GetWindowText(cs);
   params[0] = (float)atof(cs);





   TheFunctionType theFunction = NULL;

   m_gui_Combo1.GetLBText(m_gui_Combo1.GetCurSel(), cs);


   if (false)
      ;
   else if (!cs.CompareNoCase("coil"))
      theFunction = Coil;
   else if (!cs.CompareNoCase("crazy"))
      theFunction = Crazy;
   else if (!cs.CompareNoCase("Insane Scribble Ball"))
      theFunction = InsaneScribbleBall;

   dt  = (m_TMax - m_TMin) / (float)(m_NumPoints - 1);
   t   = m_TMin;
   vtx = pVertices;
   for (i = 0; i < m_NumPoints; i++)
   {
      theFunction(t, pos, nrm, clr, params);
      vtx -> position = D3DXVECTOR3( pos[0], pos[1], pos[2] );
      vtx -> normal   = D3DXVECTOR3( nrm[0], nrm[1], nrm[2] );
      vtx -> color    = D3DXCOLOR  ( clr[0], clr[1], clr[2], clr[3]);
      
      vtx++;
      t += dt;
   }

   m_pVBLines->Unlock();
}



void CAppForm::OnButton1() 
{
   CString cs;

   m_gui_Edit1.GetWindowText(cs);
   m_TMin      = (float)atof(cs);
   m_gui_Edit2.GetWindowText(cs);
   m_TMax      = (float)atof(cs);
   m_gui_Edit3.GetWindowText(cs);
   m_NumPoints = atoi(cs);

   RegenerateGeometry();
}

void CAppForm::TweenNumbers()
{
   float ptA;
   float ptB;
   float pt;
   float f;

   CString cs;

   m_gui_Edit4.GetWindowText(cs);
   ptA = (float)atof(cs);
   m_gui_Edit5.GetWindowText(cs);
   ptB = (float)atof(cs);

   f = (float)m_gui_Slider2.GetPos();
   f = (100.0f - f) / 100.0f;
   pt = (ptA - ptB) * f + ptB;

   char s[32];
   sprintf(s, "%.5f", pt);
   m_gui_Edit6.SetWindowText(s);
}
void CAppForm::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
   if ((void*)pScrollBar != &m_gui_Slider2)
      return;

   TweenNumbers();
   RegenerateGeometry();

   // stupid warnings
   nPos = nPos;
   nSBCode = nSBCode;
}

void CAppForm::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	OnVScroll(nSBCode, nPos, pScrollBar);
}
